SET TERM ^ ;

create or alter procedure DEVICEEVENTS_INSERT (
    ID_DB integer,
    ID_EVENTTYPE integer,
    ID_CTRL integer,
    ID_READER integer,
    NOTE varchar(100),
    "TIME" timestamp,
    ID_VIDEO integer,
    ID_USER integer,
    ESS1 integer,
    ESS2 integer,
    IDSOURCE integer,
    IDSERVERTS integer)
returns (
    ID_EVENT integer)
as
declare variable ID_DEV integer;
declare variable ID_PLAN integer;
declare variable FLAGCARD integer;
declare variable ID_ORG integer;
declare variable ID_PEP integer;
declare variable FLAG integer;
declare variable SURNAME varchar(50);
declare variable NAME varchar(50);
declare variable PATRONYMIC varchar(50);
declare variable ID_CARD varchar(32);
declare variable GUESTNOTE varchar(250);
declare variable FULLNAME varchar(410);
declare variable SOUND blob sub_type 0 segment size 80;
declare variable DOOR_NAME varchar(50);
declare variable SERVER_NAME varchar(50);
declare variable ANALIT integer;
Begin
/*
IF (:id_eventtype in (0)) THEN
    BEGIN
        fullname='';
        door_name='no_device_name';
        server_name='no_server_name';
        select d.name, s.name from device d
        join server s on d.id_server=s.id_server
        where d.id_ctrl=:id_ctrl  and d.id_reader is null
         into :door_name, :server_name ;
        if(:id_ctrl is null) then fullname = 'no id_ctrl';
        if(:id_reader is null) then fullname = fullname||' no id_reader';
        fullname=fullname||', idserverts='||:idserverts;
        INSERT INTO events (ID_DB, ID_EVENTTYPE, DATETIME, ID_DEV, ID_PLAN, IDSOURCE, IDSERVERTS, NOTE)
        VALUES (:ID_DB, :ID_EVENTTYPE, :"TIME", :ID_DEV, :ID_PLAN, :IDSOURCE, :IDSERVERTS,
        'Device event='||:note
        ||', device="'||:door_name
        ||'", server="'||:server_name
        ||'", '||:fullname

        );
   end

else     */

select ID_DEV from device where  (ID_DB=:ID_DB) AND (ID_CTRL=:ID_CTRL) AND (ID_READER=:id_reader)  INTO :ID_DEV;
--INSERT INTO EVENTS2 (ID_DB,ID_DEV, ID_EVENTTYPE,ID_OBJECT,DATETIME,NOTE,DEVTIME,ID_SERVER,ID_EVENTTS) VALUES (1,:ID_DEV,:ID_EVENTTYPE,1,'NOW',:NOTE,:"TIME",:IDSOURCE,:IDSERVERTS);

IF (:id_eventtype IN (49,53,54,57,58)) THEN
    BEGIN
      SELECT MAX(ID_DEV), MAX(ID_PLAN) FROM DEVICE WHERE (ID_DB=:ID_DB) AND (ID_CTRL=:ID_CTRL) AND (ID_READER=:id_reader)
      INTO :ID_DEV, :ID_PLAN;
      INSERT INTO EVENTS(ID_DB, ID_EVENTTYPE, DATETIME, ID_DEV, ID_PLAN, IDSOURCE, IDSERVERTS)
      VALUES (:ID_DB, :ID_EVENTTYPE, :"TIME", :ID_DEV, :ID_PLAN, :IDSOURCE, :IDSERVERTS);
    END

else IF (:id_eventtype IN (46,47,48,50, 145, 81)) THEN
    BEGIN
      SELECT MAX(ID_DEV) FROM DEVICE WHERE (ID_DB=:ID_DB) AND (ID_CTRL=:ID_CTRL) AND (ID_READER=:id_reader)
      INTO :ID_DEV;

      fullname = ' <'||coalesce(:note, '')||'>';
      id_pep = :ess1;                            
      id_org = :ess2;
      select C.FLAG, c.ID_PEP from card c where (c.ID_CARD STARTING WITH :NOTE)
      into :FLAGCARD, :id_pep;

      SELECT P.ID_ORG, P.SOUND, P.ID_PLAN, P.FLAG, P.note
        , coalesce(' '||p.surname,'')||coalesce(' '||p.name,'')||coalesce(' '||p.patronymic,'')
      FROM PEOPLE P where (P.ID_PEP = :id_pep)
      INTO :id_org, :sound, :id_plan, :flag, :GUESTNOTE
        , :fullname
      ;

      if ((:id_eventtype=46) and (coalesce(:id_pep, 0)<>0)) then
         id_eventtype=65;

         if ((:id_eventtype=50) and (:id_pep is null)) then
         id_eventtype=80;

      if ((:id_eventtype=50) and (bitAnd(:flagcard,1)<>0) ) then

         fullname = fullname||coalesce(' в '||:GUESTNOTE, '');



      if ((:id_eventtype=145) and (bitAnd(:flagcard,1)<>0) ) then
         fullname = fullname||coalesce(' в '||:GUESTNOTE, '');

       if((:id_eventtype=50) or (:id_eventtype=47) or (:id_eventtype=65)) then
        execute procedure event_analit :id_db, :ID_DEV, :ID_PEP, :id_eventtype returning_values :analit;

      fullname = substring(:fullname from 2 for 100) || ',';

      INSERT INTO EVENTS(ID_DB, ID_EVENTTYPE, DATETIME, ID_DEV, ID_PLAN, ID_CARD, ANALIT,  ESS1, ESS2, NOTE, IDSOURCE, IDSERVERTS)
      VALUES (:ID_DB, :ID_EVENTTYPE, :"TIME", :ID_DEV, :ID_PLAN, :NOTE, :analit ,:ID_PEP, :ID_ORG, :fullname, :IDSOURCE, :IDSERVERTS);
    END

else  IF (:id_eventtype IN (51,52,55,56)) THEN
    BEGIN
      SELECT MAX(ID_DEV), MAX(ID_PLAN) FROM DEVICE WHERE (ID_DB=:ID_DB) AND (ID_CTRL=:ID_CTRL) AND (ID_READER=:id_reader)
      INTO :ID_DEV, :ID_PLAN;
      INSERT INTO EVENTS(ID_DB, ID_EVENTTYPE, DATETIME, ID_DEV, ID_PLAN, ESS1, IDSOURCE, IDSERVERTS)
      VALUES (:ID_DB, :ID_EVENTTYPE, :"TIME", :ID_DEV, :ID_PLAN, :ESS1, :IDSOURCE, :IDSERVERTS);
    END

else begin   /*Неизвестное событие*/
        fullname='';
        door_name='no_device_name';
        server_name='no_server_name';
        select d.name, s.name from device d
        join server s on d.id_server=s.id_server
        where d.id_ctrl=:id_ctrl  and d.id_reader is null
         into :door_name, :server_name ;
        if(:id_ctrl is null) then fullname = 'no id_ctrl';
        if(:id_reader is null) then fullname = fullname||' no id_reader';
        fullname=fullname||', idserverts='||:idserverts;
        INSERT INTO events (ID_DB, ID_EVENTTYPE, DATETIME, ID_DEV, ID_PLAN, IDSOURCE, IDSERVERTS, NOTE)
        VALUES (:ID_DB, :ID_EVENTTYPE, :"TIME", :ID_DEV, :ID_PLAN, :IDSOURCE, :IDSERVERTS,
        'Device event='||:note
        ||', device="'||:door_name
        ||'", server="'||:server_name
        ||'", '||:fullname );

    end

select distinct gen_id(gen_event_id,0)
    from RDB$DATABASE
    into :id_event;
    suspend;

post_event('EventMonitor');   
if ((:id_eventtype=50) and (:sound is not null)) then post_event('EventSound');
if ((:id_eventtype=50) and (bitAND(:flag,128)<>0)) then post_event('EventSpeak');


end^

SET TERM ; ^

DESCRIBE PROCEDURE DEVICEEVENTS_INSERT
'Процедура вставки события в таблицу events';

GRANT SELECT ON DEVICE TO PROCEDURE DEVICEEVENTS_INSERT;

GRANT INSERT ON EVENTS TO PROCEDURE DEVICEEVENTS_INSERT;

GRANT SELECT ON CARD TO PROCEDURE DEVICEEVENTS_INSERT;

GRANT SELECT ON PEOPLE TO PROCEDURE DEVICEEVENTS_INSERT;

GRANT EXECUTE ON PROCEDURE EVENT_ANALIT TO PROCEDURE DEVICEEVENTS_INSERT;

GRANT SELECT ON SERVER TO PROCEDURE DEVICEEVENTS_INSERT;

GRANT EXECUTE ON PROCEDURE DEVICEEVENTS_INSERT TO SYSDBA;